#ifndef __CClosestNote__
#define __CClosestNote__

#include <EGUI.h>
#include <EMusic.h>

namespace Exponent
{
	namespace SCal
	{
		/**
		 * @class CClosestNotePanel CClosestNotePanel.hpp
		 * @brief Compute the closest note to a frequency
		 *
		 * @date 20/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 * 
		 * $Id: CClosestNotePanel.hpp,v 1.2 2007/02/11 02:20:27 paul Exp $
		 */
		class CClosestNotePanel : public CControlPanel, public IActionListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param root The root control that this control is being added to
			 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
			 * @param area The area of this control relative to the root controls top left
			 */
			CClosestNotePanel(IControlRoot *root, const long uniqueId, const CRect &area);

			/**
			 * Destruction
			 */
			virtual ~CClosestNotePanel();

//	===========================================================================

			/**
			 * Handle the action event
			 */
			virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * Compute the closest division
			 */
			void computeClosestNote();

//	===========================================================================

			CTextEdit *m_closestNoteFreqEditBox;				/**< Edit box for closest frequency */
			CTextLabel *m_closestNoteOutputValueLabel;			/**< Label for closest division output */
		};
	}
}
#endif	// End of CClosestNote.hpp